PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144682521"
 Author = "jayas.jayas"
 Desc = "Transformer HL/LV Connection"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144682245
  Nodes = 
   {
   Output("BRKR",36,-36)
    {
    Type = Integer
    Dim  = [4]
    }
   Output("FLT",36,18)
    {
    Type = Integer
    }
   Input("FLTLCN",36,-18)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   Pen(Black)
   Line(36,-18,27,-18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.datalabel([1548,324],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([1548,378],3,0,-1)
    {
    Name = "B2T1"
    }
   0.datalabel([1548,432],3,0,-1)
    {
    Name = "B2T2"
    }
   -Wire-([684,738],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([720,738],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([1296,1314],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1296,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1548,666],3,0,-1)
    {
    Name = "B3T1"
    }
   0.datalabel([1548,720],3,0,-1)
    {
    Name = "B3T2"
    }
   0.datalabel([1548,774],3,0,-1)
    {
    Name = "B4T1"
    }
   0.datalabel([1296,1170],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1296,1188],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1296,1206],6,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1296,1224],6,0,-1)
    {
    Name = "B4"
    }
   -Sticky-([1206,126],0)
    {
    Name = ""
    Font = 1
    Bounds = 1206,126,1314,162
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Sticky-([1530,126],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1530,126,1692,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   -ControlPanel-([1206,252],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(44438576)
    Slider(44330920)
    Slider(44273592)
    }
   -ControlPanel-([1206,396],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(44435856)
    Slider(44270872)
    Slider(44267856)
    }
   0.datalabel([1548,828],3,0,-1)
    {
    Name = "B4T2"
    }
   0.tbreakn([1620,270],4,0,20)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.tbreakn([1620,666],4,0,120)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B3T1"
    TO2 = "B3T2"
    }
   0.var([1512,432],0,44267856,60)
    {
    Name = "B2T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.var([1512,378],0,44270872,50)
    {
    Name = "B2T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.var([1512,324],0,44273592,40)
    {
    Name = "B1T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   -ControlPanel-([1206,630],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(44433136)
    Slider(44326648)
    Slider(44323792)
    }
   -ControlPanel-([1206,774],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(44430360)
    Slider(44320936)
    Slider(44317968)
    }
   0.var([1512,828],0,44317968,160)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1512,774],0,44320936,150)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.37"
    Units = "s"
    Collect = "1"
    }
   0.var([1512,720],0,44323792,140)
    {
    Name = "B3T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1512,666],0,44326648,100)
    {
    Name = "B3T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   -Wire-([1440,1188],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1548,270],3,0,-1)
    {
    Name = "B1T1"
    }
   0.var([1512,270],0,44330920,10)
    {
    Name = "B1T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   -Wire-([1656,306],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1656,378],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1656,414],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.logic([1692,414],6,0,210)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1674,756],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1620,738],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1674,666],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.logic([1710,684],0,0,240)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1674,666],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.logic([1710,792],6,0,250)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1674,846],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1674,846],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.datalabel([828,756],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([684,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([720,774],0,0,-1)
    {
    Name = "Tfd"
    }
   -ControlPanel-([18,216],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(45234160)
    Meter(45274520)
    Slider(45237016)
    Meter(45222688)
    Meter(45058088)
    Meter(45055176)
    Meter(45110440)
    Meter(45194024)
    }
   -Wire-([1602,360],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1602,360],6,0,-1)
    {
    Name = "FLTLCN"
    }
   0.datalabel([1620,738],6,0,-1)
    {
    Name = "FLTLCN"
    }
   0.import([1404,1188],0,0,190)
    {
    Name = "FLTLCN"
    }
   0.export([1386,1314],4,0,300)
    {
    Name = "FLT"
    }
   0.export([1350,1260],4,0,310)
    {
    Name = "BRKR"
    }
   -ControlPanel-([702,342],0)
    {
    Name = "X-former"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,108,126
    Dial(45298784)
    }
   -Sticky-([522,90],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 522,90,684,180
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the voltage to obtain the matching
VAR flow at each end."
    }
   -Sticky-([18,126],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,126,144,162
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -Sticky-([18,612],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,612,126,648
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -ControlPanel-([18,342],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Slider(45241568)
    Meter(45280344)
    Slider(45244152)
    Meter(45154984)
    Meter(45025320)
    Meter(45052192)
    }
   0.datamerge([1314,1242],4,0,290)
    {
    N = "4"
    Type = "1"
    Disp = "1"
    }
   0.tbreakn([1620,846],4,0,180)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   0.tbreakn([1620,468],4,0,80)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   0.logic([1692,306],0,0,200)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([1764,270],0,0,270)
    {
    Type = "2"
    Inv = "0"
    }
   0.logic([1764,450],6,0,220)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([1800,450],4,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1800,270],6,0,-1)
    {
    Name = "B1"
    }
   0.logic([1782,828],6,0,260)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([1818,828],4,0,-1)
    {
    Name = "B4"
    }
   0.datalabel([1818,648],2,0,-1)
    {
    Name = "B3"
    }
   0.var_switch([1710,828],0,44430360,170)
    {
    Name = "42 B4"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.var_switch([1710,648],0,44433136,110)
    {
    Name = "42 B3"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.var_switch([1692,450],0,44435856,70)
    {
    Name = "42 B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.var_switch([1692,270],0,44438576,30)
    {
    Name = "42 B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.tfaultn([792,756],4,0,230)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   0.var([648,774],0,44442192,130)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = ""
    Collect = "1"
    }
   0.var([648,738],0,44444832,90)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   -ControlPanel-([18,666],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(45159984)
    Dial(45188104)
    Slider(44444832)
    Slider(44442192)
    Slider(45301872)
    }
   -Sticky-([252,810],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 252,810,378,1008
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> no Fault "
    }
   -Sticky-([18,810],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 18,810,216,990
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between B1 and HV T1
  2=> FT2:
          Between LV T1and B2
  3=> FT3:
          midpoint on LV Dist Bus
  4=> FT4:
          Between B4 and load"
    }
   -Sticky-([576,846],0)
    {
    Name = ""
    Font = 1
    Bounds = 576,846,954,1008
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
An AB to ground Fault is located between B4 and the Distribution Load,
at Fault Location 4.

The fault occurs at 0.2 sec and has a duration of 0.2 sec.

Breaker B5 is set to trip at 0.37 sec and remain open for the 
duration of the simulation."
    }
   0.logic([1782,648],0,0,280)
    {
    Type = "2"
    Inv = "0"
    }
   -Sticky-([1224,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 1224,1116,1332,1152
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   -Sticky-([864,468],0)
    {
    Name = ""
    Font = 1
    Bounds = 864,468,1116,576
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, click on the switch.
On = Recorder will record data.
Off = Recorder will NOT record data.

You can turn off and  on each recorder individually."
    }
   -ControlPanel-([900,324],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(45346720)
    Switch(45349440)
    Switch(45352160)
    }
   -ControlPanel-([936,180],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(45148248)
    Slider(45151288)
    }
   -Sticky-([936,126],0)
    {
    Name = ""
    Font = 1
    Bounds = 936,126,1044,162
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback Recorders"
    }
   -Divider-([18,594],0)
    {
    Size(1152,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1170,1044],0)
    {
    Size(450,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1170,90],0)
    {
    Size(0,1296)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([828,108],0)
    {
    Size(0,486)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 1144682245
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1 ")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([36,72],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [36,72]
    Icon = [-1,-1]
    Extents = 0,0,1476,1116
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,1476,268],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(45293728,"V1a",0,,,)
     Curve(45003848,"V1b",1,,,)
     Curve(44981616,"V1c",2,,,)
     }
    Graph([0,268],[0,0,1476,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(45061000,"I1a",0,,,)
     Curve(45071872,"I1b",1,,,)
     Curve(45063912,"I1c",2,,,)
     }
    Graph([0,536],[0,0,1476,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(45131976,"I10",0,,,)
     }
    PGraph([0,804],[0,0,1476,249],"PolyGraph")
     {
     Options = 2
     Curve(44992776,"Br1a",0,,,1)
     Curve(45006624,"Br1b",1,,,1)
     Curve(45047240,"Br1c",2,,,1)
     }
    }
   }
  }
 Module("Plots_1")
  {
  Desc = ""
  FileDate = 1144682245
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(1,25,"B3  B4")
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   -Plot-([18,90],0)
    {
    Title = "Breaker 3 Status"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [-1,-1]
    Icon = [-1,-1]
    Extents = 0,0,900,1080
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,900,259],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(45095976,"V3a",0,,,)
     Curve(45098920,"V3b",1,,,)
     Curve(45143360,"V3c",2,,,)
     }
    Graph([0,259],[0,0,900,259],"Current")
     {
     Options = 9
     Units = ""
     Curve(45101832,"I3a",0,,,)
     Curve(45104744,"I3b",1,,,)
     Curve(45191000,"I3c",2,,,)
     }
    Graph([0,518],[0,0,900,259],"Current")
     {
     Options = 9
     Units = ""
     Curve(45137360,"I30",0,,,)
     }
    PGraph([0,777],[0,0,900,240],"PolyGraph")
     {
     Options = 2
     Curve(45107664,"Br3a",0,,,1)
     Curve(45196904,"Br3b",1,,,1)
     Curve(45199680,"Br3c",2,,,1)
     }
    }
   -Plot-([954,360],0)
    {
    Title = "Bus 4 Status"
    Draw = 1
    Area = [0,0,864,810]
    Posn = [954,360]
    Icon = [-1,-1]
    Extents = 0,0,864,810
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,864,255],"Current")
     {
     Options = 9
     Units = ""
     Curve(45210216,"I4a",0,,,)
     Curve(45213048,"I4b",1,,,)
     Curve(45215960,"I4c",2,,,)
     }
    Graph([0,255],[0,0,864,255],"Current")
     {
     Options = 9
     Units = ""
     Curve(45219824,"I40",0,,,)
     }
    PGraph([0,510],[0,0,864,237],"PolyGraph")
     {
     Options = 2
     Curve(45202456,"Br4a",0,,,1)
     Curve(45116264,"Br4b",1,,,1)
     Curve(45118928,"Br4c",2,,,1)
     }
    }
   }
  }
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 1144682245
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2 ")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([36,36],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [36,36]
    Icon = [-1,-1]
    Extents = 0,0,1476,1116
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,1476,268],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(44984528,"V2a",0,,,)
     Curve(44987448,"V2b",1,,,)
     Curve(45017496,"V2c",2,,,)
     }
    Graph([0,268],[0,0,1476,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(44975688,"I2a",0,,,)
     Curve(44978704,"I2b",1,,,)
     Curve(45069232,"I2c",2,,,)
     }
    Graph([0,536],[0,0,1476,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(45134448,"I20",0,,,)
     }
    PGraph([0,804],[0,0,1476,249],"PolyGraph")
     {
     Options = 2
     Curve(44997240,"Br2a",0,,,1)
     Curve(45009400,"Br2b",1,,,1)
     Curve(44999880,"Br2c",2,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144682406
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.datalabel([396,1224],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([432,1224],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([468,1224],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([792,1224],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([828,1224],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([864,1224],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([2088,828],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([2106,864],0,0,170)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2106,900],0,0,190)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([288,1224],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([324,1224],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([360,1224],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([684,1224],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([720,1224],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([756,1224],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([612,1296],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2124,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2124,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2124,1062],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,900],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,936],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2106,900],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2106,864],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([2106,936],0,0,210)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1512,1242],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1710,1188],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([1746,1188],2,0,-1)
    {
    Name = "FT2"
    }
   -Wire-([1728,1278],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([1710,1440],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([1764,1350],2,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([2124,1098],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([612,576],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([1044,648],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([1548,1242],2,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1476,1242],2,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1818,1440],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([954,558],0,0,-1)
    {
    Name = "FT2"
    }
   -Wire-([630,1332],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1026,1332],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([2124,288],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([2124,324],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([2124,360],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([2124,648],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([2124,684],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([2160,648],0,44975688,940)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-20.0"
    Max = "20.0"
    }
   0.pgb([2160,684],0,44978704,920)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-20.0"
    Max = "20.0"
    }
   0.pgb([2160,234],0,44981616,1130)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([2160,522],0,44984528,110)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-30.0"
    Max = "30.0"
    }
   0.pgb([2160,558],0,44987448,130)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-30.0"
    Max = "30.0"
    }
   0.datalabel([2250,162],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([2250,198],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([2250,234],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([2286,162],0,44992776,1160)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([2250,522],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([2250,558],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([2286,522],0,44997240,980)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2286,594],0,44999880,960)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([2250,288],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([2160,198],0,45003848,1150)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([2286,198],0,45006624,1140)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2286,558],0,45009400,970)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([2106,162],0,0,380)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2106,198],0,0,390)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2088,126],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([2124,162],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([2124,198],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([2124,558],2,0,-1)
    {
    Name = "V2B"
    }
   0.pgb([2160,594],0,45017496,150)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-30.0"
    Max = "30.0"
    }
   -Wire-([2250,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2250,360],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([2250,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2250,396],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([2250,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2250,756],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([2124,522],2,0,-1)
    {
    Name = "V2A"
    }
   0.pgb([2286,648],0,45025320,930)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-30"
    Max = "30"
    }
   0.datalabel([2250,720],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([2250,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2250,684],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([2250,648],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2250,648],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([2250,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,558],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2250,594],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([2124,720],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([2124,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2124,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2124,648],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2124,288],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2124,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2124,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,162],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,198],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,288],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2250,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2124,594],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([2106,594],0,0,140)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2106,558],0,0,120)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2106,522],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2106,558],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2106,594],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([2124,234],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([2106,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2106,198],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2106,162],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([2106,234],0,0,400)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2250,324],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([2286,234],0,45047240,1120)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([2106,522],0,0,100)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2088,486],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([2088,486],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([2286,684],0,45052192,910)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-10"
    Max = "10"
    }
   0.pgb([2286,324],0,45055176,1080)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2286,288],0,45058088,1100)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([2160,288],0,45061000,1110)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.5"
    }
   0.pgb([2160,360],0,45063912,1070)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.5"
    }
   -Wire-([2124,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2124,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2124,756],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([2160,720],0,45069232,900)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-20.0"
    Max = "20.0"
    }
   0.pgb([2160,324],0,45071872,1090)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.5"
    }
   -Wire-([2088,126],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([2124,396],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([2088,828],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([2124,864],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([2124,900],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([2124,936],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1080,1224],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1116,1224],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1152,1224],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([2124,990],0,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([2124,1026],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([2124,1062],0,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([2124,1098],0,0,-1)
    {
    Name = "I30"
    }
   0.datalabel([1188,1224],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1224,1224],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1260,1224],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([468,1368],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([864,1368],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2250,990],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([2250,1026],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([2250,864],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([2250,900],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([2250,936],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([2250,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2250,1188],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([2250,1224],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([2250,1260],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([2250,1314],0,0,-1)
    {
    Name = "P4"
    }
   0.pgb([2160,864],0,45095976,180)
    {
    Name = "V3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-25.0"
    Max = "25.0"
    }
   0.pgb([2160,900],0,45098920,200)
    {
    Name = "V3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-25.0"
    Max = "25.0"
    }
   0.pgb([2160,990],0,45101832,830)
    {
    Name = "I3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([2160,1026],0,45104744,810)
    {
    Name = "I3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([2286,864],0,45107664,860)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([2286,990],0,45110440,820)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-30"
    Max = "30"
    }
   0.pgb([2286,1314],0,45113352,620)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([2286,1224],0,45116264,670)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2286,1260],0,45118928,650)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([1584,1242],2,0,-1)
    {
    Name = "B4"
    }
   0.datalabel([1260,1368],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1224,756],0,0,-1)
    {
    Name = "F4"
    }
   0.voltmetergnd([1134,738],0,0,160)
    {
    Name = "V3"
    }
   0.datalabel([612,558],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([1044,666],0,0,-1)
    {
    Name = "F3"
    }
   -Wire-([1494,1332],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1566,1332],0,0,-1)
    {
    Name = "tap"
    }
   -Wire-([522,522],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([1170,720],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([1062,630],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1224,738],0,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([594,522],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([954,576],0,0,-1)
    {
    Name = "F2"
    }
   -Wire-([1098,522],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([2160,396],0,45131976,1020)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.4"
    Max = "0.6"
    }
   0.pgb([2160,756],0,45134448,880)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-4.0"
    Max = "5.0"
    }
   0.pgb([2160,1098],0,45137360,780)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([2286,1350],0,45140448,610)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([2160,936],0,45143360,220)
    {
    Name = "V3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-25.0"
    Max = "25.0"
    }
   -Sticky-([2142,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 2142,36,2250,72
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   -Wire-([234,1332],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   -Wire-([630,1332],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   -Wire-([1026,1332],0,0,-1)
    {
    Vertex="0,0;0,198"
    }
   0.var([36,1494],0,45148248,320)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   0.var([36,1530],0,45151288,340)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   -Wire-([234,1332],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([846,522],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.pgb([2142,1458],0,45154984,370)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "20"
    Max = "30"
    }
   -Wire-([594,522],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([936,540],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([1440,1260],0,0,-1)
    {
    Name = "Breaker"
    }
   -Wire-([1242,720],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.var_pot([1656,1314],0,45159984,300)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "4"
    Value = "4"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([1728,1314],0,0,310)
    {
    IType = "2"
    OType = "1"
    }
   0.mux_array([1746,1386],6,0,480)
    {
    DPath = "0"
    }
   0.datalabel([1782,1188],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([1566,1260],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   0.datatap([1476,1242],6,0,520)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1512,1242],6,0,510)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1548,1242],6,0,500)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1584,1242],6,0,490)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1800,1206],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   0.datalabel([1818,1188],2,0,-1)
    {
    Name = "FT4"
    }
   0.mux_array([1746,1242],0,0,700)
    {
    DPath = "0"
    }
   0.datatap([1818,1188],6,0,730)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1782,1188],6,0,740)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1746,1188],6,0,750)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1710,1188],6,0,760)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1818,1440],0,0,570)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1782,1440],0,0,580)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1746,1440],0,0,590)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1710,1440],0,0,600)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1782,1440],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([1746,1440],0,0,-1)
    {
    Name = "F2"
    }
   -Wire-([1692,1422],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datalabel([1836,1026],4,0,-1)
    {
    Name = "Breaker"
    }
   0.datalabel([1836,1044],0,0,-1)
    {
    Name = "Faulttype"
    }
   0.resistive_load([1314,720],0,0,-1)
    {
    P = "20.0 [MW]"
    V = "14.4 [kV]"
    SD = "0"
    }
   0.reactive_load([1386,720],0,0,-1)
    {
    S = "5.0 [MVAR]"
    V = "14.4 [kV]"
    F = "$(f)"
    SD = "0"
    }
   0.datalabel([1764,1314],1,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([1764,1314],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.unity([1764,1314],4,0,460)
    {
    IType = "2"
    OType = "1"
    }
   0.var_pot([1836,1314],2,45188104,330)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "4"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   0.pgb([2160,1062],0,45191000,790)
    {
    Name = "I3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([2286,1026],0,45194024,800)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-10"
    Max = "10"
    }
   0.pgb([2286,900],0,45196904,850)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([2286,936],0,45199680,840)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([2286,1188],0,45202456,690)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   -Wire-([2106,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2106,1206],0,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([2106,1242],0,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([2106,1278],0,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([2106,1314],0,0,-1)
    {
    Name = "I40"
    }
   0.pgb([2142,1206],0,45210216,680)
    {
    Name = "I4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-20.0"
    Max = "20.0"
    }
   0.pgb([2142,1242],0,45213048,660)
    {
    Name = "I4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-20.0"
    Max = "20.0"
    }
   0.pgb([2142,1278],0,45215960,640)
    {
    Name = "I4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-20.0"
    Max = "20.0"
    }
   0.datalabel([2250,1350],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([2142,1314],0,45219824,630)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-5.0"
    Max = "4.0"
    }
   0.pgb([2142,1422],0,45222688,360)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([702,504],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([702,504],6,0,-1)
    {
    Name = "tap"
    }
   -ControlPanel-([738,630],0)
    {
    Name = "Display"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,72,126
    Meter(45251144)
    }
   0.var([432,594],3,45234160,70)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "5.4"
    Units = "deg"
    Collect = "1"
    }
   0.var([378,594],3,45237016,60)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   -Wire-([1314,522],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.var([1332,594],5,45241568,80)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([1386,594],5,45244152,90)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "40"
    Min = "0.0"
    Value = "24.6"
    Units = "kV"
    Collect = "1"
    }
   0.source3R([414,522],6,0,410)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.source3R([1350,522],2,0,420)
    {
    Name = "Stn2"
    MVA = "100.0 [MVA]"
    Vm = "25.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.pgb([720,504],3,45251144,1060)
    {
    Name = "Tap Position"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.90"
    Max = "1.10"
    }
   -Wire-([1494,1404],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1566,1404],0,0,-1)
    {
    Name = "Ron"
    }
   0.breaker3([1206,522],0,0,540)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "1e-6 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-1.067"
    Q = "-0.02394"
    }
   0.tpflt([576,540],0,0,1040)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1080,630],4,0,990)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1260,720],4,0,950)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "1"
    }
   0.breaker3([1206,720],0,0,530)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "1e-6 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "-0.02227"
    Q = "-0.1044"
    }
   0.xfmr-3p2w([810,522],0,0,1030)
    {
    Name = "Trans 1 "
    Tmva = "50 [MVA]"
    f = "$(f)"
    YD1 = "0"
    YD2 = "0"
    Lead = "1"
    Xl = "0.1 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "2"
    View = "1"
    Dtls = "1"
    V1 = "230.0 [kV]"
    V2 = "25 [kV]"
    Enab = "1"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "1 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.ground([810,558],1,0,-1)
    {
    }
   0.ground([792,558],1,0,-1)
    {
    }
   0.breaker3([558,522],4,0,560)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "1e-6 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "1.493"
    Q = "1.263"
    }
   0.annotation([1458,1386],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.pgb([2286,360],0,45274520,1050)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([2286,396],0,45277432,1010)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([2286,720],0,45280344,890)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-30"
    Max = "30"
    }
   0.pgb([2286,756],0,45283256,870)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.breaker3([1062,522],4,0,550)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "1e-6 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "1.282"
    Q = "0.1922"
    }
   -Bus-([1134,504],0,47313696,-1)
    {
    P1 = [0,0]
    P2 = [0,234]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.tpflt([918,540],0,0,1000)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Sticky-([702,774],0)
    {
    Name = ""
    Font = 1
    Bounds = 702,774,846,846
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Tap Changer settings refer
 to final Turns ratio in Per Unit "
    }
   -Sticky-([1206,846],0)
    {
    Name = ""
    Font = 1
    Bounds = 1206,846,1422,972
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Source impedance:
RRL is recommended since it is more
realistic than a RL connection.
The Thevenin results are the same.
Default is 0.1 pu or 52.9 ohm positive
sequence, 0.1 pu zero sequence."
    }
   0.pgb([2160,162],0,45293728,1170)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   .Plots_B2([1080,414],0,0,20)
    {
    }
   .Plots_1([1206,414],0,0,30)
    {
    }
   .Plots_B1([558,414],0,0,10)
    {
    }
   0.var_pot([1458,1332],0,45298784,290)
    {
    Name = "off load tap"
    Group = ""
    Display = "0"
    NDP = "5"
    Value = "3"
    F1 = ".9"
    F2 = ".95"
    F3 = "1.0"
    F4 = "1.05"
    F5 = "1.1"
    F6 = "1.15"
    F7 = "1.2"
    F8 = "1.25"
    F9 = "1.3"
    F10 = "1.35"
    }
   0.var([1458,1404],0,45301872,350)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   0.recorder2_0([1152,1296],0,0,710)
    {
    FName = "stn3"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([756,1296],0,0,720)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([360,1296],0,0,770)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.const([72,1260],1,0,240)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([108,1296],6,0,430)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([72,1332],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([144,1296],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.const([540,1260],1,0,260)
    {
    Name = ""
    Value = "10.0"
    }
   0.const([918,1260],1,0,280)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([576,1296],6,0,440)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([540,1332],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([72,1530],0,0,-1)
    {
    Vertex="0,0;954,0"
    }
   -Wire-([72,1494],0,0,-1)
    {
    Vertex="0,0;846,0"
    }
   0.select([954,1296],6,0,450)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([990,1296],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([918,1332],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   0.var_switch([108,1224],1,45346720,230)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([576,1224],1,45349440,250)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([954,1224],1,45352160,270)
    {
    Name = "en Record3"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([1836,1080],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1908,1080],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([1836,1044],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1908,1026],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Sticky-([360,414],0)
    {
    Name = ""
    Font = 1
    Bounds = 360,414,450,450
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   -Sticky-([1296,414],0)
    {
    Name = ""
    Font = 1
    Bounds = 1296,414,1386,450
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   .Controls([1944,1062],4,0,470)
    {
    }
   -Sticky-([36,18],0)
    {
    Name = ""
    Font = 1
    Bounds = 36,18,504,180
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Case Description: 
- Two Thevinen Impedance sources connected via a D-Y transformer.
- System voltage is 230kV/25kV settable via source equivalents.
- Simulates two systems with a feeder load.
- Four fault positions for full fault control ahead and behind station relays.
- Three breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible."
    }
   -Sticky-([648,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 648,36,1044,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   0.multimeter([666,522],0,0,40)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([1008,522],4,0,50)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([684,522],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Divider-([54,1152],0)
    {
    Size(1962,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([2016,1512],0)
    {
    Size(0,-1458)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Wire-([2106,1422],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2106,1422],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([2106,1458],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2106,1458],0,0,-1)
    {
    Name = "V2rms"
    }
   }
  }
 }

